{strip}
	{fetch_form assign=form from=1}{if !empty($form) && $form.fields}
		<div class="text-tmp title-28">
			<h3>{$form.name}</h3>
			{$form.content nofilter}
		</div>

		<form class="form validation_js" action="{$SITE_URL}/{$form.endpoint}" novalidate id="{$form.fileName}" method="{$form.method}">

			{foreach from=$form.fields item=field}

				{if $field.fieldType eq 'I'}
					{* input fields *}
					{include file="../form/elements/input.tpl" field=$field}
					{* /input fields *}
				{/if}

				{if $field.fieldType eq 'C'}
					{* checkbox *}
					{include file="../form/elements/checkbox.tpl" field=$field}
					{* /checkbox *}
				{/if}

				{if $field.fieldType eq 'S'}
					{* select *}
					{include file="../form/elements/select.tpl" field=$field}
					{* /select *}
				{/if}

				{if $field.fieldType eq 'T'}
					{* textarea *}
					{include file="../form/elements/textarea.tpl" field=$field}
					{* /textarea *}
				{/if}

				{if $field.fieldType eq 'I' && $field.inputType eq 'file'}
					{* file *}
					{include file="../form/elements/input-file.tpl" field=$field}
					{* /file *}
				{/if}

				{* Соглашение на обработку персональных данных *}
				{include file="../form/elements/agreement.tpl"}
				{* /Соглашение на обработку персональных данных *}

				{* csrf token *}
				<input type="hidden" name="token" value="{$token}" class="d-none">
				{* csrf token *}

				{* captcha *}
				{include file="../form/elements/captcha.tpl"}
				{* /captcha *}

				{if $field.fieldType eq 'B'}
					{* button submit *}
					{include file="../form/elements/button.tpl" field=$field}
					{* /button submit *}
				{/if}

			{/foreach}
		</form>
	{/if}

{/strip}
